#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

using namespace std;

int main() {
    int numRows, numCols, subRows, subCols;
    cin >> numRows >> numCols >> subRows >> subCols;

    vector<int> arrayA(numRows * numCols);
    for (int i = 0; i < numRows * numCols; i++) {
        cin >> arrayA[i];
    }

    vector<vector<int>> matrixA(numRows, vector<int>(numCols));
    for (int i = 0; i < numRows; i++) {
        for (int j = 0; j < numCols; j++) {
            matrixA[i][j] = arrayA[i * numCols + j];
        }
    }

    int maxVal = INT_MIN;
    int maxRowIdx = 0;
    int maxColIdx = 0;
    for (int i = 0; i < numRows; i++) {
        for (int j = 0; j < numCols; j++) {
            if (matrixA[i][j] > maxVal) {
                maxVal = matrixA[i][j];
                maxRowIdx = i;
                maxColIdx = j;
            }
        }
    }

    int tmp = matrixA[numRows / 2][numCols / 2];
    matrixA[numRows / 2][numCols / 2] = maxVal;
    matrixA[maxRowIdx][maxColIdx] = tmp;

    vector<vector<int>> sortedMatrix(numRows, vector<int>(numCols));
    for (int i = 0; i < numRows; i++) {
        sort(matrixA[i].begin(), matrixA[i].end());
        int idx = numCols / 2;
        for (int j = 0; j < numCols; j++) {
            sortedMatrix[i][j] = matrixA[i][(j + idx) % numCols];
        }
    }

    vector<vector<vector<int>>> submatrices(numRows - subRows + 1, vector<vector<int>>(numCols - subCols + 1, vector<int>(subRows * subCols)));
    for (int i = 0; i < numRows - subRows + 1; i++) {
        for (int j = 0; j < numCols - subCols + 1; j++) {
            for (int k = 0; k < subRows; k++) {
                for (int l = 0; l < subCols; l++) {
                    submatrices[i][j][k * subCols + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }

    int totalSum = 0;
    for (int i = 0; i < numRows - subRows + 1; i++) {
        for (int j = 0; j < numCols - subCols + 1; j++) {
            for (int val : submatrices[i][j]) {
                totalSum += val;
            }
        }
    }

    cout << totalSum << endl;

    return 0;
}